## Parameter files for valley floor width extraction using LSDTopoTools

Fiona Clubb, December 2021

Durham University, fiona.j.clubb@durham.ac.uk

To supplement Clubb et al. (2022) Continuous measurements of valley floor width in mountainous landscapes, _Earth Surface Dynamics Discussions_

--------------

This directory contains the parameter files needed to reproduce the valley floor width extraction for the landscapes analysed in Clubb et al. (2022). 
The sub-directories contains the files for each landscape consisting of:

* `coords_csv`: a CSV file containing the latitude and longitude of the upstream point on the river network, used as a starting point for the valley floor extraction.
* `LSDTT_valleys.param`: the parameter file used to run LSDTopoTools on each landscape, with the parameter choices used (including channel relief and slope thresholds) for valley floor identification.
* `DEM_name.hdr`: the ENVI .hdr file for each DEM, which gives the coordinate bounding box. This can be used to download the DEM.

-------------
For instructions on how to install LSDTopoTools and run the valley extraction tools please see [our documentation](https://lsdtopotools.github.io/LSDTT_documentation/), or visit our [GitHub repo](https://github.com/LSDtopotools/LSDTopoTools2).